(function(dojo) {
    dojo.declare("NextendElementColor", NextendElement, {
        constructor: function(args) {
            dojo.mixin(this, args);
            this.value = 'ffffff';
            this.hidden = dojo.byId(this.hidden);

            dojo.connect(this.hidden, 'change', this, 'reset');

            this.reset();
            if (this.alpha == 1)
                this.alpha = true;
            else
                this.alpha = false;

            jQuery(this.hidden).spectrum({
                showAlpha: this.alpha,
                preferredFormat: (this.alpha == 1 ? "hex8" : "hex6"),
                showInput: false,
                showButtons: false,
                move: dojo.hitch(this, 'onChange'),
                change: dojo.hitch(this, 'onChange')
            });

        },
        reset: function() {
            if (this.value != this.hidden.value) {
                if (this.hidden.value.charAt(0) == '#')
                    this.hidden.value = this.hidden.value.substring(1);
                if (this.hidden.value != this.value) {
                    this.value = this.hidden.value;
                    jQuery(this.hidden).spectrum("set", this.value);
                }
            }
        },
        onChange: function(color) {
            var c = color.toString((this.alpha == 1 ? "hex8" : "hex6"));
            if (c.charAt(0) == '#')
                this.hidden.value = c.substring(1);
            else
                this.hidden.value = c;
            this.fireEvent(this.hidden, 'change');
        }
    });
})(ndojo);