<?php 
/*------------------------------------------------------------------------
# mod_jo_accordion - Vertical Accordion Menu for Joomla 1.5 
# ------------------------------------------------------------------------
# author    Roland Soos 
# copyright Copyright (C) 2011 Offlajn.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.offlajn.com
-------------------------------------------------------------------------*/
?>
<?php
// Report all PHP errors (see changelog)
defined('_JEXEC') or die('Restricted access');

if (!extension_loaded('gd') || !function_exists('gd_info')) {
    echo "The Accordion Menu needs the <a href='http://php.net/manual/en/book.image.php'>GD module</a> enabled in your PHP runtime 
    environment. Please consult with your System Administrator and he will 
    enable it!";
    return;
}

/* For demo parameter editor */
if(defined('DEMO')){
  if(isset($_SESSION[$_REQUEST['module']."_params"])){
    $params = new JParameter($_SESSION[$_REQUEST['module']."_params"]);
  }
  if($_REQUEST['module'] != $module->module) return;
}
$module->navClassPrefix = 'off-nav-';
$module->instanceid = 'offlajn-accordion-'.$module->id.'-1';
$module->containerinstanceid = $module->instanceid.'-container';

if(version_compare(JVERSION,'1.6.0','ge')) {
  include(dirname(__FILE__).DS.'params'.DS.'library'.DS.'flatArray.php');
  $params->loadArray(flat_array($params->toArray()));
}
//flat_array
/*
Loading the right class for the menu type
*/
$type = preg_replace("/[^A-Za-z0-9]/", '', $params->get('menutype'));
if($type == '' or !file_exists(dirname(__FILE__).DS.'types'.DS.$type.DS.'menu.php')){
  echo JText::_('Menu type not exists!');
  return;
}

require_once(dirname(__FILE__).DS.'types'.DS.$type.DS.'menu.php');

$class = 'Offlajn'.ucfirst($type).'Menu';

$menu = new $class($module, $params);
$menu->generateItems();

/*
Loading the template file for the theme
*/
$templateDir = dirname(__FILE__).DS.'template'.DS;

$theme = $params->get('theme', 'default');
$tmpl = $templateDir.$theme.'.php';

if(!file_exists($tmpl)){
  $tmpl = $templateDir.'default.php';
  if(!file_exists($tmpl)){
    echo JText::_('Template file missing for Accordion menu. Please reinstall the module.');
    return;
  }
}

/*
Loading the template container file for the theme
*/
$containerTmpl = $templateDir.$theme.'-cont.php';

if(!file_exists($containerTmpl)){
  $containerTmpl = $templateDir.'default-cont.php';
  if(!file_exists($containerTmpl)){
    echo JText::_('Template file missing for Accordion menu. Please reinstall the module.');
    return;
  }
}
?>
<div class="noscript">
<?php
/*
Render the menu
*/
include($containerTmpl);
?>
</div>
<?php
/*
Build the Javascript cache and scopes
*/ 
require_once(dirname(__FILE__).DS.'classes'.DS.'cache.class.php');
$cache = new OfflajnMenuThemeCache('default', $module, $params);

$document =& JFactory::getDocument();
$cache->addJs(dirname(__FILE__).DS.'js'.DS.'dojo.js');
$cache->addJs(dirname(__FILE__).DS.'js'.DS.'easing.js');
$cache->addJs(dirname(__FILE__).DS.'js'.DS.'cookie.js');
$cache->addJs(dirname(__FILE__).DS.'js'.DS.'accordionmenu.js');


/*
Build the CSS
*/ 
$cache->addCss(dirname(__FILE__) .DS. 'themes' .DS. 'clear.css.php');
$cache->addCss(dirname(__FILE__) .DS. 'themes' .DS. $theme .DS. 'theme.css.php');

/*
Load image helper
*/
require_once(dirname(__FILE__).DS.'classes'.DS.'ImageHelper.php');

/*
Set up enviroment variables for the cache generation
*/
$module->url = JUri::root(true).'/modules/'.$module->module.'/';
$cache->addCssEnvVars('module', $module);
$cache->addCssEnvVars('helper', new OfflajnAccordionHelper($cache->cachePath, $cache->cacheUrl));

/*
Add cached contents to the document
*/
$cacheFiles = $cache->generateCache();
$document->addStyleSheet($cacheFiles[0]);
$document->addStyleDeclaration('
.noscript div#'.$module->instanceid.'-container dl.level1 dl{
  position: static;
}
.noscript div#'.$module->instanceid.'-container dl.level1 dd.parent{
  height: auto !important;
  display: block;
  visibility: visible;
}
');
$document->addScript($cacheFiles[1]);

$document->addScriptDeclaration("
accordionDojo.addOnLoad(accordionDojo, function(){
  var dojo = this;
  dojo.query('.noscript').removeClass('noscript');
  new AccordionMenu({
    node: dojo.byId('".$module->instanceid."'),
    instance: '".$module->instanceid."',
    classPattern: /".$module->navClassPrefix."[0-9]+/,
    mode: '".$params->get( 'mode', 'onclick' )."', 
    interval: '".$params->get( 'duration', '500' )."', 
    level: 1,
    easing:  ".$params->get( 'easing', 'dojo.fx.easing.cubicInOut' ).",
    accordionmode:  ".$params->get( 'accordionmode', 1 )."
  })
});
");
?>